////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// File: "CAnimation.h"
// Author: Alex Czarnopys (AC)
// Purpose: This is the header file for the CAnimation class.
//			The CAnimation class makes animations for objects.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma once
#include "SGD_Math.h"
#include <windows.h>
#include <vector>
#include <string>
using std::vector;

struct tFrame
{
	RECT rSource; 		// The rect around the frame of the sheet
	float fDuratrion;	// The time to wait on the frame b4 changing
	POINT ptAnchor; 	// When you draw it subtract the anchor point 
	std::string Trigger;
	vector<RECT> collisionRects;
};

class CAnimation
{
	int m_nFrameCur;		// Curent frame index
	int m_nImageID;			// Sprite sheet to animate
	int m_nNumFrames;		// Number of frames in the animation
	tFrame m_CurFrame;		// Current frame shown

	vector<tFrame> m_Frames;
	
	double m_dFrameTimer;	// Tracks how long weve been on the current frame
	float m_fSpeed;			// How fast to play the animation (1.0 normal)
	bool m_bIsLooping;		// Whether to loop or not
	bool m_bIsReverse;		// Direction to animate, forward or reverse
	bool m_bIsPlaying;		// Whether or not the animation is playing

public:
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Function: "CAnimation"
	// Last Modified: June 21, 2008
	// Purpose: Default constructor for a CAnimation.
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	CAnimation();

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Function: "~CAnimation"
	// Last Modified: June 21, 2008
	// Purpose: Default destructor for a CAnimation
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	~CAnimation();

	/////////////////////////////////
	// Function: Accessors
	// Purpose: Return specified type
	/////////////////////////////////
	int GetImageID(void)			{ return m_nImageID; }
	int GetNumFrames(void)			{ return m_nNumFrames; }
	tFrame GetCurFrame(void)		{ return m_CurFrame; }
	double GetFrameTimer(void)		{ return m_dFrameTimer; }
	float GetSpeed(void)			{ return m_fSpeed; }
	bool GetIsLooping(void)			{ return m_bIsLooping; }
	bool GetIsReverse(void)			{ return m_bIsReverse; }
	bool GetIsPlaying(void)			{ return m_bIsPlaying; }
	int GetCurFrameIndex(void)		{ return m_nFrameCur; }

	/////////////////////////////////
	// Function: Modifiers
	// Purpose: Modify specified type
	/////////////////////////////////
	void SetImageID(int nImageID)				{ m_nImageID = nImageID; }
	void SetNumFrames(int nNumFrames)			{ m_nNumFrames = nNumFrames; }
	void SetCurFrame(tFrame CurFrame)			{ m_CurFrame = CurFrame; }
	void SetFrameTimer(double dFrameTimer)		{ m_dFrameTimer = dFrameTimer; }
	void SetSpeed(float fSpeed)					{ m_fSpeed = fSpeed; }
	void SetIsLooping(bool IsLooping)			{ m_bIsLooping = IsLooping; }
	void SetIsReverse(bool IsReverse)			{ m_bIsReverse = IsReverse; }
	void SetIsPlaying(bool IsPlaying)			{ m_bIsPlaying = IsPlaying; }

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Function: "CreateAnimation"
	// Last Modified: June 24, 2008
	// Purpose: Creates an animation initially. TO BE CALLED BEFORE ADD FRAME ALWAYS.
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	void CreateAnimation(char* szFileName, DWORD Transparent, tFrame FirstFrame, float fSpeed = 1.0f, bool bIsLooping = false, bool bIsReverse = false);
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Function: "AddFrame"
	// Last Modified: June 24, 2008
	// Purpose: Adds a frame to the animation, adds a tFrame to the Frame list specifically.
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	void AddFrame(tFrame NewFrame);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Function: "Play"
	// Last Modified: June 21, 2008
	// Purpose: Goes to the first frame of the animation and begins playing.
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	void Play(void);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Function: "Stop"
	// Last Modified: June 21, 2008
	// Purpose: Pauses the current animation. 
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	void Stop(void);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Function: "Resume"
	// Last Modified: June 21, 2008
	// Purpose: Unpauses the current animation.
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	void Resume(void);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Function: "Update"
	// Last Modified: June 24, 2008
	// Purpose: Updates the current animation using the passed in elapsed time.
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	void Update(double dElapsedTime);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Function: "Render"
	// Last Modified: June 24, 2008
	// Purpose: Renders the animation based on the values passed in.
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	void Render(int nPosX,int nPosY, float fScaleX = 1.0f, float fScaleY = 1.0f, float fRotX = 0.0f, float fRotY = 0.0f, float fRot = 0.0f, DWORD color = -1, float fZBuffer = 0.0f);

};